 ; Ŀ
 ;   Scrub - chgtext for any or all attribute values in selected inserts.  
 ;   Copyright 1993, 1995, 1996, 2000 by Rocket Software                   
 ;   Leech Sushi - the fast food of a new millennium.                      
 ; 

 ; Ŀ
 ;   Blured: attribute value editor.                                       
 ;   If attnam contains a value edits only attributes with that tag,       
 ;   otherwise does them all.  Calls Chug for search and replace.          
 ;   Returns a list: the no. of changes and the no. of attributes changed. 
 ; 
 (DEFUN BLURED (ss attnam / chnges attchg blkchg pold pnew pos enam esav entt
                                               vall blokup asoc1 lischg chgnum)
  (setq chnges 0)
  (setq attchg 0)
  (setq blkchg 0)
  (if (/= (type old) 'STR) (setq old ""))
  (setq pold (getstring T (strcat "\nOld string <" old ">: ")))
  (if (/= pold "") (setq old pold))
  (if (/= (type new) 'STR) (setq new ""))
  (setq pnew (getstring T (strcat "\nNew string (|= empty) <" new ">: ")))
  (cond ((= pnew "|")
         (setq new ""))
        ((/= pnew "")
         (setq new pnew)))
  (setq pos 0)
  (while (setq enam (ssname ss pos))
         (setq esav enam)
         (setq pos (1+ pos))
         (setq blokup ())
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                (if (or (null attnam)
                        (= (cdr (assoc 2 entt)) attnam))
                    (progn
                         (setq vall (cdr (setq asoc1 (assoc 1 entt))))
                         (setq vall (car (setq lischg (chug old new vall))))
                         (if (/= (setq chgnum (cadr lischg)) 0)
                             (progn
                                 (setq chnges (+ chnges chgnum))
                                 (setq pa (cdr (assoc 10 entt)))
                                 (croco pa)
                                 (setq attchg (1+ attchg))
                                 (setq blokup t)
                                 (entmod (subst (cons 1 vall) asoc1 entt)))))))
         (if blokup
             (progn
                  (setq blkchg (1+ blkchg))
                  (entupd esav))))
 (list blkchg attchg chnges))
 ; Ŀ
 ;   Blured end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Croco - draw a temporary marker.                           
 ; 
 (DEFUN CROCO (pa / rad colo)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq colo 7)
  (setq rad (/ (getvar "viewsize") 20))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (/ pi 2) rad) (polar pa (* 1.5 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
  (grdraw (polar pa 0 rad) (polar pa pi rad) colo)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Croco end.                                                            
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen oldlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Batter - replacement error handler.  Restores original values to      
 ;   attributes if something goes wrong.                                   
 ; 
 (DEFUN BATTER (shk)
  (if (and esav main)
      (tagout enam main))
  (setq *error* esav)
 (princ))
 ; Ŀ
 ;   Batter end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Tagin - step through an insert, substituting the tag        
 ;   names for attribute values, returns a list of the original values     
 ;   so that they can be restored.                                         
 ;   Also sets the visibility to on, and saves the original state to the   
 ;   list Main.                                                            
 ; 
 (DEFUN TAGIN (enam / entt vis vis1 tagg vall sublst)
  (setq entt (entget (setq esav enam)))
  (if (and (= (cdr (assoc 0 entt)) "INSERT")
           (assoc 66 entt))
      (progn
           (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq enam
                                                          (entnext enam)))))))
 ; Ŀ
 ;   Turn the attribute visibility on.                                     
 ; 
                  (setq vis (cdr (assoc 70 entt)))   ; get att flags
                  (setq vis1 (logand 14 vis))        ; turn visibility on
                  (setq entt (subst (cons 70 vis1) (assoc 70 entt) entt))
 ; Ŀ
 ;   Substitute the tag name for the attribute value.                      
 ; 
                  (setq tagg (cdr (assoc 2 entt)))
                  (setq vall (cdr (assoc 1 entt)))
                  (if (and tagg vall)
                      (progn
                           (setq sublst (list tagg vall vis))
                           (setq main (append main (list sublst)))
                           (entmod (subst (cons 1 tagg)
                                          (cons 1 vall) entt)))))
           (entupd esav)))
 main)
 ; Ŀ
 ;   Tagin end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Tagout - restore the original values to a block from the   
 ;   list Main.  Returns nothing.                                          
 ; 
 (DEFUN TAGOUT (enam main / entt esav pos sublst vall)
  (setq entt (entget (setq esav enam)))
  (setq pos 0)
  (while (/= (cdr (assoc 0 entt)) "SEQEND")
         (setq enam (entnext enam))
         (setq entt (entget enam))
         (setq sublst (nth pos main))
 ; Ŀ
 ;   Restore the attribute visibility flag.                                
 ; 
         (setq entt (subst (cons 70 (last sublst)) (assoc 70 entt) entt))
         (setq vall (cadr sublst))
         (setq pos (1+ pos))
         (if (and vall entt)
             (entmod (subst (cons 1 vall) (assoc 1 entt) entt))))
  (entupd esav))
 ; Ŀ
 ;   Tagout end.                                                           
 ; 

 ; Ŀ
 ;   Scrub - the vigorous entropy remover.                                 
 ; 
 (DEFUN C:SCRUB (/ errsav ss main enam attnam chnges)
  (command "undo" "m")                   ; set undo marker
  (setq errsav *error*)                  ; save the previous error handler
  (setq *error* batter)                  ; and install the new one
; (setq *error* ())
 ; Ŀ
 ;   Get an ss of inserts.                                                 
 ; 
  (write-line "Select blocks to edit: ")
  (setq ss (ssget (list (cons 0 "INSERT") (cons 66 1))))
  (setq main ())                         ; list of attribute values to restore
 ; Ŀ
 ;   Use the first insert in the ss to display the attribute tag names     
 ;   and ask which one to edit.                                            
 ; 
  (if (and ss (setq enam (ssname ss 0)))
      (progn
           (setq main (tagin enam))
 ; Ŀ
 ;   Prompt for an attribute to edit, get the tag.                         
 ; 
           (setq attnam (nentsel "\nAttribute to edit or <Return> for all: "))
           (if attnam (setq attnam (cdr (assoc 2 (entget (car attnam))))))
           (if attnam (princ attnam))
 ; Ŀ
 ;   Restore the original values to the block from the list Main.          
 ; 
           (tagout enam main)
 ; Ŀ
 ;   Now call blocked to edit the insertions.                              
 ; 
          (setq chglis (blured ss attnam))))
  (setq *error* errsav)        ; restore the original error handler
  (setq blkchg (car chglis))
  (setq attchg (cadr chglis))
  (setq chnges (caddr chglis))
  (if (= attchg 0)
      (write-line "No changes made.")
      (write-line (strcat (itoa chnges) " change"
                          (if (= 1 chnges) "" "s") " made in "
                          (itoa attchg) " attribute"
                          (if (= 1 attchg) "" "s") " in "
                          (itoa blkchg) " block"
                          (if (= 1 blkchg) "" "s") ".")))
  (setq *error* esav)
 (princ))